/* This handy addLoadEvent function from Simon Willison allows you to stack up 'window.onload' events 
without them stepping on each other's toes. It's explained here - http://www.sitepoint.com/blog-post-view.php?id=171578 */

function addLoadEvent(func) {
  var oldonload = window.onload;
  if (typeof window.onload != 'function') {
    window.onload = func;
  }
  else {
    window.onload = function() {
      oldonload();
      func();
    }
  }
}